﻿<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zaświadczenie o zarobkach</title>
		<script runat="server">
	
	//Elementy wg nazwy
	//Tutaj wpisujemy nazwy elementów które mają zostać uwzględnione w zesatwieniu nawet jeżeli
	//nie spełniają innych kryteriów.
	//Każda nazwa musi być wpisana w '"' i oddzielona ',' od następnej.
	static readonly string[] nazwyDodatków = new string[] {};

	//A tutaj tak samo, ale elementy, które mają być zawsze pominięte    
    //static readonly string[] pomińDodatki = new string[] { };
	
	//Uwzględniemy wszystkie elementy opodatkowane ewentualnie poza zaliczkami
	//Oraz elementy nieopodatkowane wg podanych założeń	
	Hashtable wyjatki = null;
		    
	bool Wchodzi(WypElement e) {
		if (wyjatki==null) {
			wyjatki = new Hashtable();
			foreach (string nazwa in nazwyDodatków)
				wyjatki[nazwa.ToLower()] = true;
            if (srpars.Wykluczone != null)
                foreach (DefinicjaElementu de in srpars.Wykluczone)
                    wyjatki[de.Nazwa.ToLower()] = false;
        }
		
        object obj = wyjatki[e.Definicja.Nazwa.ToLower()];
		if (obj!=null)
			return (bool)obj;

        if (!e.Definicja.DoWyplaty && !srpars.Niewplywajacy)
            return false;
            
		if (e.Definicja.Info.Opodatkowany)
			switch (e.RodzajZrodla) {
				case RodzajŹródłaWypłaty.Zaliczka:
				case RodzajŹródłaWypłaty.SpłataZaliczki:
					return srpars.ZaliczkiISplatyOpodatkowane;
				default:
					return true;
			}
			
		switch (e.RodzajZrodla) {
			case RodzajŹródłaWypłaty.Zaliczka:
			case RodzajŹródłaWypłaty.SpłataZaliczki:
				return srpars.ZaliczkiISplatyNieopodatkowane;

			case RodzajŹródłaWypłaty.Pożyczka:
			case RodzajŹródłaWypłaty.PożyczkaSpłata:
				return srpars.PozyczkiISplaty;
				
			default:
				return !e.Definicja.Info.Potrącenie ? srpars.DodatkiNieopodatkowane : srpars.PotraceniaNieopodatkowane;
		}		
	}
	
    public class PrnParams: OkresContext {
    
        public PrnParams(Context context): base(context) {
            wgDatyWypłaty = true;
            YearMonth to = new YearMonth(Aktualny);
            to -= 1;
            YearMonth from = to - 2;
            base.Okres = new FromTo(from.FirstDay, to.LastDay);
        }
    
        [Browsable(false)]
        public override Date Aktualny {
            get { return base.Aktualny; }
            set { base.Aktualny = value; }
        }
    
    
        [Priority(1)]
        public override FromTo Okres {
            get { return base.Okres; }
            set { base.Okres = value; }
        }
    
        bool wgDatyWypłaty;
        [Priority(2)]
        public bool WgDatyWypłaty {
            get { return wgDatyWypłaty; }
            set {
                wgDatyWypłaty = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool etat = true;
        [Priority(3)]
        public bool WypłatyZaEtat {
            get { return etat; }
            set {
                etat = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool umowa = false;
        [Priority(4)]
        public bool Umowy {
            get { return umowa; }
            set {
                umowa = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool inne = false;
        [Priority(5)]
        public bool InneWypłaty {
            get { return inne; }
            set {
                inne = value;
                OnChanged(EventArgs.Empty);
            }
        }
		
		bool pozostajeZero = false;
        [Priority(6)]        
		public bool PozostajeZero {
            get { return pozostajeZero; }
            set {
                pozostajeZero = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    public enum InfoKwota {
        Netto,
        Brutto,
        [Caption("Netto i brutto")]
        NettoBrutto
    }
    
    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //W raporcie uwzględniaj następujące elementy nieopodatkowane:
        //Pożyczki i spłaty pożyczek
        //static readonly bool pozyczkiISplaty = false;
        bool pozyczkiISplaty = false;
        [Priority(1)]
        [Caption("Pożyczki i spłaty")]
        public bool PozyczkiISplaty {
            get { return pozyczkiISplaty; }
            set {
                pozyczkiISplaty = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Zaliczki opodatkowane i ich spłaty
        //static readonly bool zaliczkiISplatyOpodatkowane = false;
        bool zaliczkiISplatyOpodatkowane = false;
        [Priority(2)]
        [Caption("Zalicz. i spłaty opodatk.")]
        public bool ZaliczkiISplatyOpodatkowane {
            get { return zaliczkiISplatyOpodatkowane; }
            set {
                zaliczkiISplatyOpodatkowane = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        //Zaliczki nieopodatkowane i ich spłaty
        //static readonly bool zaliczkiISplatyNieopodatkowane = false;
        bool zaliczkiISplatyNieopodatkowane = false;
        [Priority(3)]
        [Caption("Zalicz. i spł. nieopodatk.")]
        public bool ZaliczkiISplatyNieopodatkowane {
            get { return zaliczkiISplatyNieopodatkowane; }
            set {
                zaliczkiISplatyNieopodatkowane = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        //Dodatki nieopodatkowane
        //static readonly bool dodatkiNieopodatkowane = true;
        bool dodatkiNieopodatkowane = true;
        [Priority(4)]
        [Caption("Dodatki nieopodatk.")]
        public bool DodatkiNieopodatkowane {
            get { return dodatkiNieopodatkowane; }
            set {
                dodatkiNieopodatkowane = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        //Potrącenie nieopodatkowane
        //static readonly bool potraceniaNieopodatkowane = false;
        bool potraceniaNieopodatkowane = false;
        [Priority(5)]
        [Caption("Potrącenia nieopodatk.")]
        public bool PotraceniaNieopodatkowane {
            get { return potraceniaNieopodatkowane; }
            set {
                potraceniaNieopodatkowane = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Podsumowanie funduszy pożyczkowych
        //static readonly bool podsumowanieFunduszy = false;    
        bool podsumowanieFunduszy = false;
        [Priority(6)]
        [Caption("Podsum. funduszy")]
        public bool PodsumowanieFunduszy {
            get { return podsumowanieFunduszy; }
            set {
                podsumowanieFunduszy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool pelneStanowisko = false;
        [Priority(7)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool niewplywajacy = false;
        [Priority(8)]
        [Caption("Uwzględnij niepieniężne")]
        public bool Niewplywajacy {
            get { return niewplywajacy; }
            set {
                niewplywajacy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool zaswiadczenie = false;
        [Priority(9)]
        [Caption("Okres zaświadczenia")]
        public bool Zaswiadczenie {
            get { return zaswiadczenie; }
            set {
                zaswiadczenie = value;
                OnChanged(EventArgs.Empty);
            }
        }

        InfoKwota info = InfoKwota.NettoBrutto;
        [Priority(10)]
        [Caption("Informacja o kwocie")]
        public InfoKwota Info {
            get { return info; }
            set {
                info = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        DefinicjaElementu[] wykluczone;
        [Priority(11)]
        [Caption("Wyklucz elementy")]
        public DefinicjaElementu[] Wykluczone {
            get { return wykluczone; }
            set {
                wykluczone = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }		
		                        
    PrnParams pars;
    [Context(Required=true)]
    public PrnParams Params {
        get { return pars; }
        set { pars = value; }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
	            
            void OnContextLoad(Object sender, EventArgs args) {
                Pracownik pracownik = (Pracownik)dc[typeof(Pracownik)];
                PracHistoria historia = pracownik[pars.Aktualny];

                report = ReportHeader1;
                ReportHeader1["MIEJSCOWOSC"] = GetMiejscowosc(historia);

                string zameldowany = "";
                if (historia.Plec != 0) {
                    Pan.EditValue = "Pan:";
                    Zamieszkały.EditValue = "Zamieszkały:";
                    zameldowany = "<br>Zameldowany:";
                }
                else {
                    Pan.EditValue = "Pani:";
                    Zamieszkały.EditValue = "Zamieszkała:";
                    zameldowany = "<br>Zameldowana:";
                }

                if (!historia.AdresZamieszkania.IsEmpty())
                    Zameldowany.EditValue = zameldowany + " <strong>" + historia.AdresZameldowania.Linia1 + ", " + historia.AdresZameldowania.Linia2 + "</strong>";


                Pracownik.EditValue = pracownik.ImięNazwisko;
                Adres.EditValue = historia.Adres.Linia1 + ", " + historia.Adres.Linia2;
                Pesel.EditValue = historia.PESEL;

                if (pars.WypłatyZaEtat) {
                    FromTo okres = historia.Etat.OkresZatrudnienia;
                    string sto = okres.To == Date.MaxValue ? ". . . . . . . . . . . . . . ." : "<b>" + okres.To + "</b>";
                    string płeć = historia.Plec != 0 ? "zatrudniony" : "zatrudniona";
                    Info.EditValue = "jest " + płeć + " w naszym zakładzie pracy <b>" +
                        CaptionAttribute.EnumToString(historia.Etat.TypUmowy).ToLower() + "</b><br>" +
                        "od dnia: <b>" + okres.From + "</b> " +
                        (historia.Etat.TypUmowy != TypUmowyOPrace.NaCzasNieokreślony ? "do dnia: " + sto : "") + "<br>" +
                        "na stanowisku: <b>" + GetStanowisko(historia) + "</b>.";
                }
                else
                    Info.EditValue = "wykonuje pracę w naszym zakładzie na podstawie umowy zlecenia/o dzieło.";

                Set<YearMonth> miesiace = new Set<YearMonth>(); 
                decimal brutto = 0;
                decimal netto = 0;

                SubTable elementy;
                PlaceModule płace = PlaceModule.GetInstance(pracownik);

                ArrayList listZajecia = new ArrayList();
                ArrayList listAlimenty = new ArrayList();

                Date data = ((ActualDate)dc[typeof(ActualDate)]).Actual;
                
                foreach (Pracownik pp in pracownik.PracownicyPowiązani) {
                    if (pars.WgDatyWypłaty)
                        elementy = płace.WypElementy.WgDaty[pp];
                    else
                        elementy = płace.WypElementy.WgPracownik[pp];
                    elementy = new SubTable(elementy, pars.Okres);

                    foreach (WypElement e in elementy) {
                        try {
                            if (Wchodzi(e)) {
                                bool ok;
                                switch (e.Wyplata.Typ) {
                                    case TypWyplaty.Etat:
                                        ok = pars.WypłatyZaEtat; break;
                                    case TypWyplaty.Umowa:
                                        ok = pars.Umowy; break;
                                    default:
                                        ok = pars.InneWypłaty; break;
                                }
                                if (ok) {
                                    if (e.Definicja.Info.Opodatkowany)
                                        brutto += e.Wartosc;
                                    netto += e.Netto;
                                    YearMonth ym = new YearMonth(pars.WgDatyWypłaty ? e.Data : e.Okres.To);
                                    miesiace.Add(ym);
                                }
                            }
                        }
                        catch { Msg(); }
                    }

                    foreach (ZajęcieKomornicze zk in pp.ZajęciaKomornicze) {
                        if (zk.Data > pars.Okres.To)
                            continue;
                        if (pars.PozostajeZero) {
                            if (pars.Okres.To >= data && zk.DataSplaty < data)
                                continue;
                        } else {
                            if (zk.DataSplaty < data)
                                continue;
                        }
                        if (zk.Element.Nazwa == "Alimenty")
                            listAlimenty.Add(zk);
                        else
                            listZajecia.Add(zk);
                    }
                }

                if (listZajecia.Count > 0 || listAlimenty.Count > 0)
                    labelZajecia.EditValue =
                        "Wynagrodzenie to jest obciążone z tytułu wyroków sądowych lub innych tytułów:";
                else
                    labelZajecia.EditValue =
                        "Wynagrodzenie to nie jest obciążone z tytułu wyroków sądowych lub innych tytułów.";

                if (listZajecia.Count > 0)
                    Grid1.DataSource = listZajecia;
				else
					Grid1.Visible = false;

                if (listAlimenty.Count > 0)
                    Grid2.DataSource = listAlimenty;
				else
					Grid2.Visible = false;

                int mm = miesiace.Count;
                if (mm != 0) {
                    brutto = Soneta.Tools.Math.RoundCy(brutto/mm);
                    netto = Soneta.Tools.Math.RoundCy(netto/mm);
                }

                Brutto.EditValue = Currency.SłownieWalutaUpr(brutto);
                Słownie.EditValue = Currency.SłownieWaluta(brutto);

                Netto.EditValue = Currency.SłownieWalutaUpr(netto);
                SłownieNetto.EditValue = Currency.SłownieWaluta(netto);

                scBrutto.Visible = (srpars.Info == InfoKwota.Brutto || srpars.Info == InfoKwota.NettoBrutto);
                scNetto.Visible = (srpars.Info == InfoKwota.Netto || srpars.Info == InfoKwota.NettoBrutto);
                
                string ms;
                int m = pars.Okres.Months;
                if (!srpars.Zaswiadczenie)
                    switch (m)
                    {
                        case 1:
                            ms = "ostatniego miesiąca"; break;
                        case 2:
                            ms = "ostatnich dwóch miesięcy"; break;
                        case 3:
                            ms = "ostatnich trzech miesięcy"; break;
                        case 4:
                            ms = "ostatnich czterech miesięcy"; break;
                        case 5:
                            ms = "ostatnich pięciu miesięcy"; break;
                        case 6:
                            ms = "ostatnich sześciu miesięcy"; break;
                        default:
                            ms = "ostatnich " + m + " miesięcy"; break;
                    }
                else
                    ms = string.Format("okresu od {0} do {1}", pars.Okres.From, pars.Okres.To);
                miesiace1.EditValue = ms;
                miesiace2.EditValue = ms;
                
                if (srpars.PodsumowanieFunduszy) {
                    FundPożyczkowyWorker worker = new FundPożyczkowyWorker();
                    string ss = "";
                    foreach (FundPozyczkowy fp in pracownik.FunduszePozyczkowe) {
                        worker.Fundusz = fp;
                        Currency saldo = worker.DoSpłaty - worker.Wkład;
                        if (saldo > 0)
                            ss += string.Format("<tr><td width=60%>{0}</td><td><b>{1:u}</b></td></tr>",
                                fp.Definicja.Nazwa, saldo);
                    }

                    if (ss != "")
                        labelFundusze.EditValue =
                            "<br><br><table width=100% style=\"font-size: 10pt; font-family: tahoma;\">" +
                            "<tr><td colspan=2>Jest obciążone z tytułu:</td></tr>" +
                            ss +
                            "</table>";
                }              
            }

            string GetStanowisko(PracHistoria ph) {
                string stanowiskoPelne = "";
                if (srpars.PelneStanowisko)
                    stanowiskoPelne = ph.Etat.StanowiskoPełne;
                if (stanowiskoPelne.Length == 0)
                    stanowiskoPelne = ph.Etat.Stanowisko;
                return stanowiskoPelne;
            }

            string GetMiejscowosc(PracHistoria ph) {
                CoreModule core = CoreModule.GetInstance(dc);
                string miejscowosc = ReportHeader.GetPieczątka(dc).Adres.Miejscowosc;
                if (miejscowosc.Length == 0)
                    miejscowosc = core.Config.Firma.AdresSiedziby.Miejscowosc;
                if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
                    OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
                    if (!string.IsNullOrEmpty(of.Adres.Miejscowosc)) miejscowosc = of.Adres.Miejscowosc;
                }                
                return miejscowosc;
            }
            
            protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
                ZajęcieKomornicze zk = (ZajęcieKomornicze)args.Row;
                
                Grid1Column1.EditValue = zk.Element.Nazwa;
                Grid1Column2.EditValue = zk.NumerSprawy;
                if (zk.Rodzaj == RodzajeZajęciaWynagrodzenia.Kwota) {
                    Grid1Column3.EditValue = zk.Kwota.Value;
                    Grid1Column5.EditValue = zk.Pozostało.Value;
                }
                else
                    Grid1Column4.EditValue = zk.Kwota.Value;
                if (zk.DataSplaty != Date.MaxValue)
                    Grid1Column6.EditValue = zk.DataSplaty;
            }

            protected void Grid2_BeforeRow(object sender, RowEventArgs args) {
                ZajęcieKomornicze zk = (ZajęcieKomornicze)args.Row;

                Grid2Column1.EditValue = zk.Element.Nazwa;
                Grid2Column2.EditValue = zk.NumerSprawy;
                if (zk.Rodzaj == RodzajeZajęciaWynagrodzenia.Kwota) {
                    Grid2Column3.EditValue = zk.Kwota.Value;
                    Grid2Column5.EditValue = zk.Pozostało.Value;
                }
                else
                    Grid2Column4.EditValue = zk.Kwota.Value;
                if (zk.DataSplaty != Date.MaxValue)
                    Grid2Column6.EditValue = zk.DataSplaty;
            }

            public static void Msg(object obj){
            }

            public static ReportHeader report;

            public static void Msg() {
                string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
                if (report != null && !report.Title.Contains(msg))
                    report.Title += "|" + msg;
            }
		        		    
		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ZaświadczenieOZarobkach" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace" oncontextload="OnContextLoad"></ea:datacontext>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Zaświadczenie o zarobkach|<p align=right></strong>%MIEJSCOWOSC%, {0}<strong></p>" runat="server" DataMember0="Context.ActualDate.Actual"></cc1:reportheader>
			<font face="Tahoma" size="2">
			<p>
				Niniejszym zaświadcza się, że<br>
				<ea:datalabel id="Pan" runat="server" Bold="False"></ea:datalabel>
				&nbsp;
				<ea:datalabel id="Pracownik" runat="server" ></ea:datalabel>
				<br>
				<ea:datalabel id="Zamieszkały" runat="server" Bold="False"></ea:datalabel>
				&nbsp;
				<ea:datalabel id="Adres" runat="server"></ea:datalabel>
				<ea:datalabel id="Zameldowany" runat="server" Bold="False"></ea:datalabel>
				<br>
				PESEL:&nbsp;
				<ea:datalabel id="Pesel" runat="server"></ea:datalabel>
				<br>
				<ea:DataLabel id="Info" runat="server" Bold="False"></ea:DataLabel>
			</p>
            <ea:Section runat="server" ID="scBrutto">
			    <p>
				    Przeciętne wynagrodzenie BRUTTO z
				    <ea:datalabel id="miesiace1" runat="server" Bold="False"></ea:datalabel>
				    wynosi:
				    <ea:datalabel id="Brutto" runat="server"></ea:datalabel>
				    <br>
				    słownie:
				    <ea:datalabel id="Słownie" runat="server" ></ea:datalabel>
			    </p>
            </ea:Section>
            <ea:Section runat="server" ID="scNetto">
			    <p>
				    Przeciętne wynagrodzenie NETTO z
				    <ea:datalabel id="miesiace2" runat="server" Bold="False"></ea:datalabel>
				    wynosi:&nbsp;
				    <ea:datalabel id="Netto" runat="server"></ea:datalabel>
				    <br>
				    słownie:
				    <ea:datalabel id="SłownieNetto" runat="server"></ea:datalabel>
			    </p>
            </ea:Section>
			<p>
                <ea:datalabel id="labelZajecia" runat="server" Bold="False"></ea:datalabel>
			    <ea:Grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow">
				    <Columns>
					    <ea:GridColumn ID="Grid1Column1" runat="server" Align="Left" Caption="Nazwa"></ea:GridColumn>
					    <ea:GridColumn ID="Grid1Column2" runat="server" Align="Left" Width="20" Caption="Nr sprawy" Total="Info"></ea:GridColumn>
					    <ea:GridColumn ID="Grid1Column3" runat="server" Align="Left" Width="15" Caption="Kwota" Total="Sum"></ea:GridColumn>
					    <ea:GridColumn ID="Grid1Column4" runat="server" Align="Left" Width="15" Caption="Kwota miesięczna" Total="Sum"></ea:GridColumn>
					    <ea:GridColumn ID="Grid1Column5" runat="server" Align="Left" Width="15" Caption="Pozostaje" Total="Sum"></ea:GridColumn>
					    <ea:GridColumn ID="Grid1Column6" runat="server" Align="Left" Width="15" Caption="Data spłaty"></ea:GridColumn>
				    </Columns>
			    </ea:Grid>
				</br>
			    <ea:Grid id="Grid2" runat="server" onbeforerow="Grid2_BeforeRow">
				    <Columns>
					    <ea:GridColumn ID="Grid2Column1" runat="server" Align="Left" Caption="Nazwa"></ea:GridColumn>
					    <ea:GridColumn ID="Grid2Column2" runat="server" Align="Left" Width="20" Caption="Nr sprawy" Total="Info"></ea:GridColumn>
					    <ea:GridColumn ID="Grid2Column3" runat="server" Align="Left" Width="15" Caption="Kwota" Total="Sum"></ea:GridColumn>
					    <ea:GridColumn ID="Grid2Column4" runat="server" Align="Left" Width="15" Caption="Kwota miesięczna" Total="Sum"></ea:GridColumn>
					    <ea:GridColumn ID="Grid2Column5" runat="server" Align="Left" Width="15" Caption="Pozostaje" Total="Sum"></ea:GridColumn>
					    <ea:GridColumn ID="Grid2Column6" runat="server" Align="Left" Width="15" Caption="Data spłaty"></ea:GridColumn>
				    </Columns>
			    </ea:Grid>
                <ea:datalabel id="labelFundusze" runat="server" Bold="False"></ea:dataLabel>
			</p>
            <ea:pagebreak id="PageBreak1" runat="server" Required="False"></ea:pagebreak>
			<P>
				Zakład jest/nie jest*) postawiony w stan likwidacji *), nie jest prowadzone 
				postępowanie ugodowe *), upadłościowe *).
			</P>
			<p>
				<font size="1">*) niepotrzebne skreślić</font>
			</p>
			</font>
			<cc1:ReportFooter id="ReportFooter1" runat="server" Height="77px" TheEnd="False">
				<Subtitles>
					<cc1:FooterSubtitle Caption="Pieczęć zakładu pracy&lt;br&gt;&amp;nbsp;" Width="33"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Pieczęć imienna i podpis gł&#243;wnego księgowego lub osoby przez niego upoważnionej"
						Width="33"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Pieczęć imienna i podpis kierownika zakładu lub osoby przez niego upoważnionej"
						Width="33"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
		</form>
	</body>
</HTML>
